/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;

public class Main {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: unpacktara <file> <output dir>");
        }
        File taraFile = new File(args[0]);
        String outputPath = args[1];
        DataInputStream input = new DataInputStream(new FileInputStream(taraFile));
        LinkedList<ListEntry> files = new LinkedList<ListEntry>();
        int numFiles = input.readInt();
        for (int i = 0; i < numFiles; ++i) {
            String fileName = input.readUTF();
            int fileSize = input.readInt();
            files.add(new ListEntry(fileName, fileSize));
        }
        System.out.println("Unpacking " + numFiles + " files to " + new File(outputPath).getAbsolutePath());
        for (ListEntry entry : files) {
            System.out.println(entry.fileName + " [" + entry.fileSize + "]");
            byte[] bytes = new byte[entry.fileSize];
            input.read(bytes);
            File file = new File(outputPath, entry.fileName);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(bytes);
            fileOutputStream.close();
        }
    }

    static class ListEntry {
        public String fileName;
        public int fileSize;

        ListEntry(String fileName, int fileSize) {
            this.fileName = fileName;
            this.fileSize = fileSize;
        }
    }
}

