/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class TaraMaker {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: TaraMaker source_dir output_file");
            return;
        }
        TaraMaker taraMaker = new TaraMaker();
        taraMaker.run(args[0], args[1]);
    }

    private void run(String sourceDirName, String outputFileName) throws IOException {
        File sourceDir = new File(sourceDirName);
        LinkedList<FileEntry> fileEntries = new LinkedList<FileEntry>();
        this.collectFiles(sourceDir, null, fileEntries);
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(new File(outputFileName)));
        dataOutputStream.writeInt(fileEntries.size());
        for (FileEntry fileEntry : fileEntries) {
            System.out.println("Writing header: " + fileEntry.relativeName + ", " + fileEntry.file.length());
            dataOutputStream.writeUTF(fileEntry.relativeName);
            dataOutputStream.writeInt((int)fileEntry.file.length());
        }
        for (FileEntry fileEntry : fileEntries) {
            FileInputStream fileInputStream = new FileInputStream(fileEntry.file);
            byte[] bytes = new byte[(int)fileEntry.file.length()];
            if ((long)fileInputStream.read(bytes) < fileEntry.file.length()) {
                throw new RuntimeException("File read error. File name = " + fileEntry.relativeName);
            }
            fileInputStream.close();
            dataOutputStream.write(bytes);
            System.out.println("File " + fileEntry.relativeName + " data has been written");
        }
        dataOutputStream.close();
    }

    private void collectFiles(File sourceDir, String baseName, List<FileEntry> collector) {
        File[] files;
        for (File file : files = sourceDir.listFiles()) {
            String realName = baseName == null ? file.getName() : baseName + "/" + file.getName();
            if (file.isDirectory()) {
                this.collectFiles(file, realName, collector);
                continue;
            }
            if (!file.isFile()) continue;
            collector.add(new FileEntry(realName, file));
        }
    }

    class FileEntry {
        public String relativeName;
        public File file;

        FileEntry(String relativeName, File file) {
            this.relativeName = relativeName;
            this.file = file;
        }
    }
}

